#Price adjusted: Total imports & total exports

process_priceindex <- function(trade_data, var2025, price_index, index_name, base_year, compare_year){
  price_index <- price_index%>%
    mutate(
      observation_date = ymd(observation_date),
      year = year(observation_date),
      month = month(observation_date, label = TRUE, abbr = FALSE),
      month = as.factor(as.character(month))
    )
  base <-  price_index %>%
    filter(year == base_year) %>%
    select(month, !!sym(index_name)) %>%
    rename(base = !!sym(index_name))
  
  comp <-  price_index %>%
    filter(year == compare_year) %>%
    select(month, !!sym(index_name)) %>%
    rename(comp = !!sym(index_name))
  
  var2025 <- ensym(var2025)
  
  trade_data <- trade_data %>%
    mutate(month = factor(month))%>%
    left_join(base, by = c("month" = "month"))%>%
    left_join(comp, by = c("month" = "month"))%>%
    mutate(var2025_adjusted = (!!var2025)/(comp/base),
           real_cumsum_2025 = cumsum(var2025_adjusted),
           ytd_compare = real_cumsum_2025/cumsum_2024)
  return(trade_data)
}

#Total imports (price adjusted): 
IM_total_adjusted <- process_priceindex(IM_total, cifval_2025, IR, "IR", 2024, 2025)
#Total exports (price adjusted): 
EX_total_adjusted <- process_priceindex(EX_total, expval_2025, IQ, "IQ", 2024, 2025)



#Price adjusted: Region and countries

country_index_match <- function(trade_data, trade_index, ei_series, var2025){
  index_tot <- trade_index %>%
    left_join(
      ei_series %>% select(series_id, series_name),
      by = "series_id"   
    ) %>%
    mutate(series_id = str_trim(series_id)) %>% 
    filter(str_ends(series_id, "TOT"))%>%
    mutate(country = sub("-.*", "", series_name))%>%
    mutate(
      month_num = as.integer(str_remove(period, "M")),
      month = month(month_num, label = TRUE, abbr = FALSE)) %>%
    select(year, month, country, value)%>%
    pivot_wider(names_from = year, names_prefix = "index_", values_from = value)%>%
    select(month, country, "index_2024", "index_2025")
  
  var2025 <- ensym(var2025)
  
  trade_data <-trade_data %>%
    mutate(country_join = case_when(
      country %in% c("EU") ~ "European Union",
      country %in% c("South Korea") ~ "Industrialized Countries",
      country %in% c("United Kingdom") ~ "Industrialized Countries",
      TRUE ~ country
    )) %>%
    left_join(index_tot %>% mutate(month = as.character(month)) %>% 
                select(month, country, index_2024, index_2025),
              by = c("month" = "month", "country_join" = "country"))%>%
    select(-country_join)%>%
    mutate(var2025_adjusted = (!!var2025)/(index_2025/index_2024),
           real_cumsum_2025 = cumsum(var2025_adjusted),
           ytd_compare = real_cumsum_2025/cumsum_2024 -1,
           month = factor(month, levels = month.name))
  return(trade_data)
}

IM_maincountries_adjusted <- country_index_match(IM_maincountries, im_index, ei_series, cifval_2025)
EX_maincountries_adjusted <- country_index_match(EX_maincountries, ex_index, ei_series, expval_2025)

